const elements = {
	percentage: document.getElementById(""),
	volume: document.getElementById(""),
	musicTitle: document.getElementById(""),
};
let currentMusicIndex = undefined;
let loaded = false;
let allMusics = {};

let isMusicPlaying = true;

function getRndInteger(min, max) {
  return Math.floor(Math.random() * (max - min + 1)) + min;
}

window.addEventListener("load", () => {
	for (const [key, value] of Object.entries(elements)) {
		elements[key] = document.getElementById(key);
	}

	if (videoInBackground) {
		document.getElementById("video").style.opacity = 1;
		document.getElementById("video").play();
	}

	musicFiles.forEach((music, index) => {
		allMusics[index] = new Audio(music.src);
		allMusics[index].volume = elements.volume.value / 100;
		allMusics[index].loop = true;
	});

	currentMusicIndex = getRndInteger(0, musicFiles.length - 1);
	const musicFile = musicFiles[currentMusicIndex];

	elements.musicTitle.innerText = musicFile.title;

	allMusics[currentMusicIndex] = allMusics[currentMusicIndex].cloneNode(true);
	allMusics[currentMusicIndex].volume = elements.volume.value / 100;
	allMusics[currentMusicIndex].play();

	loaded = true;

	window.addEventListener("keydown", (event) => {
		if (event.key === " ") {
		event.preventDefault();
		toggleMusic();
		}
	});
});

function toggleMusic() {
	if (currentMusicIndex !== undefined) {
	  const currentMusic = allMusics[currentMusicIndex];
	  if (isMusicPlaying) {
		currentMusic.pause();
	  } else {
		currentMusic.play();
	  }
	  isMusicPlaying = !isMusicPlaying;
	}
  }

function music(left) {
	if (left && currentMusicIndex - 1 >= 0) {
		allMusics[currentMusicIndex].pause();

		const musicFile = musicFiles[currentMusicIndex - 1];
		currentMusicIndex--;

		elements.musicTitle.innerText = musicFile.title;

		allMusics[currentMusicIndex] = allMusics[currentMusicIndex].cloneNode(true);
		allMusics[currentMusicIndex].volume = elements.volume.value / 100;
		allMusics[currentMusicIndex].play();
	} else {
		if (currentMusicIndex + 1 < musicFiles.length) {
			allMusics[currentMusicIndex].pause();

			const musicFile = musicFiles[currentMusicIndex + 1];
			currentMusicIndex++;

			elements.musicTitle.innerText = musicFile.title;

			for (const [index, music] of Object.entries(allMusics)) {
				if (index != currentMusicIndex) {
					music.pause();
				}
			}

			allMusics[currentMusicIndex] = allMusics[currentMusicIndex].cloneNode(true);
			allMusics[currentMusicIndex].volume = elements.volume.value / 100;
			allMusics[currentMusicIndex].play();
		}
	}
}

function changeVolume() {
	for (const [index, music] of Object.entries(allMusics)) {
		music.volume = elements.volume.value / 100;
	}
}

function openLink(url) {
	window.invokeNative("openUrl", url);
}

window.addEventListener("keydown", (event) => {
	if (event.key.toLowerCase() == "f1") {
		event.preventDefault();

		const div = document.getElementById("container-loadingscreen");

		div.style.opacity = div.style.opacity.length <= 0 || div.style.opacity == 1 ? 0 : 1;
	}
});

window.addEventListener("message", function (e) {
	const data = e.data;

	if (!loaded) return;

	if (data.eventName == "loadProgress") {
		elements.percentage.innerText = Math.floor(data.loadFraction * 100);
		const number = convertPercentageToNumber(data.loadFraction * 100, 1, 50);

		for (let index = 1; index <= number; index++) {
			const loadingpath = document.getElementById("loadingpath" + index);

			if (loadingpath) {
				loadingpath.classList.add("Active");
			}
		}
	}
});

function convertPercentageToNumber(percentage, minNumber, maxNumber) {
	const clampedPercentage = Math.max(0, Math.min(100, percentage));

	const numberRange = maxNumber - minNumber;
	const convertedNumber = (clampedPercentage / 100) * numberRange + minNumber;

	return convertedNumber;
}

function setIntervalAtZero(callback, interval) {
	const currentTime = new Date().getTime();
	const delay = interval - (currentTime % interval);

	callback();

	setTimeout(() => {
		callback();
		setInterval(callback, interval);
	}, delay);
}
